/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.world.feature;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class MossyBoulderFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState COBBLESTONE = Blocks.field_150347_e.func_176223_P();
    private static final BlockState MOSSY_COBBLESTONE = Blocks.field_150341_Y.func_176223_P();

    public MossyBoulderFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    private boolean shouldSkipBlock(ISeedReader reader, BlockPos pos) {
        if (reader.func_175623_d(pos)) {
            return true;
        }
        Block block = reader.func_180495_p(pos).func_177230_c();
        return !MossyBoulderFeature.func_227250_b_((Block)block) && !MossyBoulderFeature.func_227249_a_((Block)block);
    }

    public boolean generate(@Nonnull ISeedReader reader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos centerPos, @Nonnull NoFeatureConfig config) {
        int radius = rand.nextInt(4) + 2;
        while (centerPos.func_177956_o() > radius && this.shouldSkipBlock(reader, centerPos.func_177977_b())) {
            centerPos = centerPos.func_177977_b();
        }
        if (centerPos.func_177956_o() <= radius) {
            return false;
        }
        for (int l = 0; l < 3; ++l) {
            int i = rand.nextInt(radius - 1);
            int j = rand.nextInt(radius - 1);
            int k = rand.nextInt(radius - 1);
            float f = (float)(i + j + k) / 3.0f + 0.5f;
            float g = f - 1.0f;
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)centerPos.func_177982_a(-i, -j, -k), (BlockPos)centerPos.func_177982_a(i, j, k))) {
                double distance = pos.func_177951_i((Vector3i)centerPos);
                if (!(distance <= (double)(f * f))) continue;
                BlockState state = distance <= (double)(g * g) || rand.nextBoolean() ? COBBLESTONE : MOSSY_COBBLESTONE;
                reader.func_180501_a(pos, state, 4);
            }
            centerPos = centerPos.func_177982_a(-1 + rand.nextInt(radius - 1), -rand.nextInt(radius - 1), -1 + rand.nextInt(radius - 1));
        }
        return true;
    }
}

